/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionUtil {
    private static final String VERSION_SPLIT_PATTERN = "(\\d+)\\.(\\d+)(([a-zA-Z0-9_\\-]+)|(\\.(\\d+)(\\.?[a-zA-Z0-9_\\-]+)?))?";
    private static final Pattern VERSION_RANGE_PATTERN = Pattern.compile("([>]?[=]?([0-9a-z.]+))?(\\s)*([<]?[=]?([0-9a-z.]+))?");
    private static Pattern VERSION_DOT_PATTERN = Pattern.compile("\\.");

    private VersionUtil() {
    }

    public static int compareVersions(String left, String right) {
        return VersionUtil.compareVersions(left, right, true);
    }

    public static int compareVersions(String left, String right, boolean isStrict) {
        return VersionUtil.compareVersions(left, right, isStrict, false);
    }

    public static int compareVersions(String left, String right, boolean isStrict, boolean handleHyphen) {
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        String[] lparts = VERSION_DOT_PATTERN.split(left);
        String[] rparts = VERSION_DOT_PATTERN.split(right);
        if (!isStrict && lparts.length != rparts.length) {
            int diff = Math.abs(lparts.length - rparts.length);
            String[] moreParts = new String[diff];
            int i = 0;
            while (i < moreParts.length) {
                moreParts[i] = "0";
                ++i;
            }
            if (lparts.length < rparts.length) {
                lparts = ArrayUtil.flatten(lparts, moreParts);
            } else {
                rparts = ArrayUtil.flatten(rparts, moreParts);
            }
        }
        int i = 0;
        while (i < lparts.length && i < rparts.length) {
            int result;
            try {
                Integer lInt = Integer.valueOf(lparts[i]);
                Integer rInt = Integer.valueOf(rparts[i]);
                result = lInt.compareTo(rInt);
            }
            catch (NumberFormatException ex) {
                result = handleHyphen ? VersionUtil.compareVersionsWithHyphen(lparts[i], rparts[i]) : lparts[i].compareToIgnoreCase(rparts[i]);
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return lparts.length - rparts.length;
    }

    static int compareVersionsWithHyphen(String left, String right) {
        boolean hasLeftHyphen = false;
        boolean hasRightHyphen = false;
        int hyphenIndex = left.indexOf(45);
        String leftPreHyphen = left;
        String leftPostHyphen = null;
        if (hyphenIndex > -1) {
            hasLeftHyphen = true;
            leftPreHyphen = left.substring(0, hyphenIndex);
            leftPostHyphen = left.substring(hyphenIndex + 1, left.length());
        }
        hyphenIndex = right.indexOf(45);
        String rightPreHyphen = right;
        String rightPostHyphen = null;
        if (hyphenIndex > -1) {
            hasRightHyphen = true;
            rightPreHyphen = right.substring(0, hyphenIndex);
            rightPostHyphen = right.substring(hyphenIndex + 1, right.length());
        }
        if (!hasLeftHyphen && !hasRightHyphen) {
            return left.compareTo(right);
        }
        if (leftPreHyphen.equals(rightPreHyphen)) {
            if (hasLeftHyphen != hasRightHyphen) {
                if (hasLeftHyphen) {
                    return -1;
                }
                if (hasRightHyphen) {
                    return 1;
                }
            } else {
                return leftPostHyphen.compareTo(rightPostHyphen);
            }
        }
        return leftPreHyphen.compareTo(rightPreHyphen);
    }

    public static Version parseVersion(String rawOutput) {
        if (StringUtil.isEmpty(rawOutput)) {
            return Version.emptyVersion;
        }
        Pattern pattern = Pattern.compile(VERSION_SPLIT_PATTERN);
        Matcher matcher = pattern.matcher(rawOutput);
        if (matcher.find()) {
            String qualifier;
            String micro;
            String major = matcher.group(1);
            String minor = matcher.group(2);
            if (matcher.group(5) != null) {
                micro = matcher.group(6);
                qualifier = matcher.group(7);
            } else {
                qualifier = matcher.group(4);
                micro = "0";
            }
            String version = String.valueOf(major) + '.' + minor + '.' + micro;
            if (!StringUtil.isEmpty(qualifier)) {
                char c = qualifier.charAt(0);
                switch (c) {
                    case '-': 
                    case '.': 
                    case '_': {
                        qualifier = qualifier.substring(1);
                        break;
                    }
                }
                version = String.valueOf(version) + '.' + qualifier;
            }
            try {
                return Version.parseVersion((String)version);
            }
            catch (Exception iae) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), "Error parsing the version string - " + version, iae);
            }
        }
        return Version.emptyVersion;
    }

    public static boolean isCompatibleVersions(String[] installedVersions, String[] requiredVersions) {
        if (installedVersions == null || requiredVersions == null) {
            return requiredVersions != null && requiredVersions.length > 0;
        }
        HashMap<String, Version> installed = new HashMap<String, Version>();
        String[] stringArray = installedVersions;
        int n = installedVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String installedVer = stringArray[n2];
            try {
                Version version = VersionUtil.parseVersion(installedVer);
                installed.put(installedVer, version);
            }
            catch (Exception e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("Error parsing the installed version {0}", installedVer));
            }
            ++n2;
        }
        stringArray = requiredVersions;
        n = requiredVersions.length;
        n2 = 0;
        while (n2 < n) {
            String required = stringArray[n2];
            if (VersionUtil.isRange(required) ? !VersionUtil.isCompatibleVersionsRange(installed, required) : !VersionUtil.isCompatibleVersionsRegex(installed, required)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isCompatibleVersions(String version, String versionRange) {
        return VersionUtil.isCompatibleVersions(new String[]{version}, new String[]{versionRange});
    }

    private static boolean isCompatibleVersionsRegex(Map<String, Version> installed, String required) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(required);
        }
        catch (PatternSyntaxException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), MessageFormat.format("The required version '{0}' should be defined as a regular-expression", required));
            return false;
        }
        for (String installedVersion : installed.keySet()) {
            Matcher matcher = pattern.matcher(installedVersion);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private static boolean isCompatibleVersionsRange(Map<String, Version> installed, String required) {
        VersionRange versionRange = new VersionRange(required);
        for (Version installedVersion : installed.values()) {
            if (!versionRange.isIncluded(installedVersion)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isRange(String versionString) {
        if ((versionString = versionString.trim()).charAt(0) == '[' || versionString.charAt(0) == '(') {
            int comma = versionString.indexOf(44);
            if (comma < 0) {
                return false;
            }
            char last = versionString.charAt(versionString.length() - 1);
            return last == ']' || last == ')';
        }
        return false;
    }

    public static boolean isEmpty(Version version) {
        if (version == null) {
            return true;
        }
        return version.equals((Object)Version.emptyVersion);
    }

    public static String parseMin(String versionRange) {
        String minVersion;
        if (StringUtil.isEmpty(versionRange)) {
            return null;
        }
        Matcher matcher = VERSION_RANGE_PATTERN.matcher(versionRange);
        if (matcher.matches() && !StringUtil.isEmpty(minVersion = matcher.group(2))) {
            return minVersion.replace('x', '0');
        }
        return null;
    }

    public static String parseMax(String versionRange) {
        String maxVersion;
        if (StringUtil.isEmpty(versionRange)) {
            return null;
        }
        Matcher matcher = VERSION_RANGE_PATTERN.matcher(versionRange);
        if (matcher.matches() && !StringUtil.isEmpty(maxVersion = matcher.group(5))) {
            return maxVersion.replace('x', '0');
        }
        return null;
    }

    public static boolean isMinimumCompatibleVersions(String[] installedVersions, String[] requiredVersions) {
        if (installedVersions == null || requiredVersions == null) {
            return requiredVersions != null && requiredVersions.length > 0;
        }
        HashMap<String, Version> installed = new HashMap<String, Version>();
        String[] stringArray = installedVersions;
        int n = installedVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String installedVer = stringArray[n2];
            try {
                Version version = VersionUtil.parseVersion(installedVer);
                installed.put(installedVer, version);
            }
            catch (Exception e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("Error parsing the installed version {0}", installedVer));
            }
            ++n2;
        }
        stringArray = requiredVersions;
        n = requiredVersions.length;
        n2 = 0;
        while (n2 < n) {
            String required = stringArray[n2];
            if (VersionUtil.isRange(required) ? !VersionUtil.isCompatibleVersionsRange(installed, required) : !VersionUtil.isMinimumCompatibleVersionsRegex(installed, required)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isMinimumCompatibleVersionsRegex(Map<String, Version> installed, String required) {
        try {
            Pattern.compile(required);
        }
        catch (PatternSyntaxException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), MessageFormat.format("The required version '{0}' should be defined as a regular-expression", required));
            return false;
        }
        for (String installedVersion : installed.keySet()) {
            Version minRequiredVersion = VersionUtil.parseVersion(required);
            if (installed.get(installedVersion).compareTo(minRequiredVersion) < 0) continue;
            return true;
        }
        return false;
    }
}

